clearvars

fig = figure
load d10K50_All.mat
cap = 4;
formatSpec = '%.2f';

t = tiledlayout(2,2,'TileSpacing','Compact', 'Padding', 'Compact');
ax = nexttile
%subplot(2, 2, 1)
line1 = semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso, '--b', 'LineWidth', 1)
hold on
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, 'k', 'LineWidth', 1)
semilogx(T_all(1:length(prob_error_OD)), prob_error_OD, '-.r')
semilogx(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, ':g')
semilogx(T_all(1:length(prob_error_OD)), prob_error_GSE, '-c')
hold on
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso, std_prob_error_Lasso, 'b', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1.15)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, std_prob_error_Lasso_A, 'k', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1.15)
errorbar(T_all(1:length(prob_error_OD)), prob_error_OD, std_prob_error_OD, '-r', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, std_prob_error_BayesGapAdaptive, '-g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_GSE, std_prob_error_BayesGapAdaptive, '-c', "LineStyle", "none", 'CapSize', cap)

xlabel('$$T$$', 'interpreter', 'latex')
ylabel('Error probability')
axis([T_all(1) T_all(end) 0 Inf])
title(['$$s = $$ ', num2str(s) , ', $$d = $$ ', num2str(d), ', $$K = $$ ', num2str(K), ', $$H_{2, \mathrm{lin}}(d) = $$ ', num2str(Hardness, formatSpec)], 'interpreter', 'latex')

grid on

%clearvars
cap = 4;

load d20K50_All.mat
ax = nexttile
line2 = semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso, '--b', 'LineWidth', 1)
hold on
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, 'k', 'LineWidth', 1)
semilogx(T_all(1:length(prob_error_OD)), prob_error_OD, '-.r')
semilogx(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, ':g')
semilogx(T_all(1:length(prob_error_OD)), prob_error_GSE, '-c')
hold on
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso, std_prob_error_Lasso, 'b', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1.15)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, std_prob_error_Lasso_A, 'k', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1.15)
errorbar(T_all(1:length(prob_error_OD)), prob_error_OD, std_prob_error_OD, '-r', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, std_prob_error_BayesGapAdaptive, '-g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_GSE, std_prob_error_BayesGapAdaptive, '-c', "LineStyle", "none", 'CapSize', cap)

xlabel('$$T$$', 'interpreter', 'latex')
ylabel('Error probability')
axis([T_all(1) T_all(end) 0 Inf])
title(['$$s = $$ ', num2str(s) , ', $$d = $$ ', num2str(d), ', $$K = $$ ', num2str(K), ', $$H_{2, \mathrm{lin}}(d) = $$ ', num2str(Hardness, formatSpec)], 'interpreter', 'latex')

grid on

%clearvars
cap = 4;

load d10K100All.mat
ax = nexttile
line3 = semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso, '--b', 'LineWidth', 1)
hold on
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, 'k', 'LineWidth', 1)
semilogx(T_all(1:length(prob_error_OD)), prob_error_OD, '-.r')
semilogx(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, ':g')
semilogx(T_all(1:length(prob_error_OD)), prob_error_GSE, '-c')
hold on
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso, std_prob_error_Lasso, 'b', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1.15)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, std_prob_error_Lasso_A, 'k', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1.15)
errorbar(T_all(1:length(prob_error_OD)), prob_error_OD, std_prob_error_OD, '-r', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, std_prob_error_BayesGapAdaptive, '-g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_GSE, std_prob_error_BayesGapAdaptive, '-c', "LineStyle", "none", 'CapSize', cap)

xlabel('$$T$$', 'interpreter', 'latex')
ylabel('Error probability')
axis([T_all(1) T_all(end) 0 Inf])
title(['$$s = $$ ', num2str(s) , ', $$d = $$ ', num2str(d), ', $$K = $$ ', num2str(K), ', $$H_{2, \mathrm{lin}}(d) = $$ ', num2str(Hardness, formatSpec)], 'interpreter', 'latex')

grid on

%clearvars
cap = 4;

load d20K100All.mat
ax = nexttile
line4 = semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso, '--b', 'LineWidth', 1)
hold on
semilogx(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, 'k', 'LineWidth', 1)
semilogx(T_all(1:length(prob_error_OD)), prob_error_OD, '-.r')
semilogx(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, ':g')
semilogx(T_all(1:length(prob_error_OD)), prob_error_GSE, '-c')
hold on
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso, std_prob_error_Lasso, 'b', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1.15)
errorbar(T_all(1:length(prob_error_OD)), prob_error_Lasso_A, std_prob_error_Lasso_A, 'k', "LineStyle", "none", 'CapSize', cap, 'LineWidth', 1.15)
errorbar(T_all(1:length(prob_error_OD)), prob_error_OD, std_prob_error_OD, '-r', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_BayesGapAdaptive, std_prob_error_BayesGapAdaptive, '-g', "LineStyle", "none", 'CapSize', cap)
errorbar(T_all(1:length(prob_error_OD)), prob_error_GSE, std_prob_error_BayesGapAdaptive, '-c', "LineStyle", "none", 'CapSize', cap)

xlabel('$$T$$', 'interpreter', 'latex')
ylabel('Error probability')
axis([T_all(1) T_all(end) 0 Inf])
title(['$$s = $$ ', num2str(s) , ', $$d = $$ ', num2str(d), ', $$K = $$ ', num2str(K), ', $$H_{2, \mathrm{lin}}(d) = $$ ', num2str(Hardness, formatSpec)], 'interpreter', 'latex')

grid on

lg = legend(ax, 'Lasso-OD-CV', 'Lasso-OD-Analytical', 'OD-LinBAI', 'Bayes-Gap-Adaptive', 'GSE', 'Box', 'off', 'NumColumns', 5)
lg.Layout.Tile = 'South';

ax = gca;
outerpos = ax.OuterPosition;
ti = ax.TightInset; 
left = outerpos(1) + ti(1);
bottom = outerpos(2) + ti(2);
ax_width = outerpos(3) - ti(1) - ti(3);
ax_height = outerpos(4) - ti(2) - ti(4);
ax.Position = [left bottom ax_width ax_height];
